"use strict";

    const radius = document.getElementById("radiusInput");
    const formula = document.getElementById("formulaChoice");
    const display = document.getElementById("resultDisplay");
    const calcBtn = document.getElementById("calculateBtn");
    
    
    calcBtn.addEventListener("click", calculate);

    function calculate() {
        let r = Number(radius.value);
        let selectedFormula = formula.value;
        let result;

        switch (selectedFormula) {
            case "diameter":
                result = getDiameter(r);
                break;

            case "circumference":
                result = getCircumference(r);
                break;

            case "area":
                result = getArea(r);
                break;

            default:
                result = 0;
                break;
        }

        display.innerHTML = "Result:" + result.toFixed(2);
    }
    
function getDiameter(r) {
    return 2 * r;
}

function getCircumference(r) {
    return 2 * Math.PI * r;
}

function getArea(r) {
    return Math.PI * Math.pow(r, 2);
}